//
//  DHDSACNIOController.h
//  DHDMX
//
//  Created by Douglas Heriot on 26/02/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "DHDSACNIOControllerDelegate.h"

@class DHDSACNIdentity;
@class DHDSACNPacket;
@class DHDMXGCDAsyncUdpSocket;

@interface DHDSACNIOController : NSObject
{
@private
	DHDMXGCDAsyncUdpSocket *sendingSocket;
	DHDMXGCDAsyncUdpSocket *receivingSocket;
	dispatch_queue_t queue;
	dispatch_queue_t filterQueue;
	
	id<DHDSACNIOControllerDelegate> _delegate;
}

//When multicast addressing is used, the UDP destination Port shall be set to the standard ACN-SDT multicast port (5568). For unicast communication the ACN-SDT multicast port shall be used by default, but methods for configuration and use of alternative ports may be provided.

@property (unsafe_unretained) id<DHDSACNIOControllerDelegate> delegate;

- (void)sendPacket:(DHDSACNPacket *)packet;
- (void)sendDMX:(NSData *)DMX toUniverse:(uint16_t)universe sequence:(uint8_t)sequence; // Just for convenience

- (BOOL)subscribeToUniverse:(uint16_t)universe;
+ (NSData *)multicastAddressForUniverse:(uint16_t)universe;

+ (DHDSACNIOController *)sharedIOController;

@end
